﻿using System.Collections.Generic;
using Jeneva.Validation.Impl;

namespace Jeneva.Validation
{
    /// <summary>
    /// Defines methods for building property path
    /// </summary>
    public interface IPathHelper
    {
        /// <summary>
        /// Builds property path using existing path and a nested property name
        /// </summary>
        /// <param name="path">existing path</param>
        /// <param name="name">nested property name</param>
        /// <returns>property path text</returns>
        string BuildPath(LinkedList<PathNode> path, string name);

        /// <summary>
        /// Creates a new instance of the path list
        /// </summary>
        /// <returns>instance of the path list</returns>
        LinkedList<PathNode> CreateNew();

        /// <summary>
        /// Sets top node target
        /// </summary>
        /// <param name="path">existing path</param>
        /// <param name="target">target DTO object</param>
        void SetTopNodeTarget(LinkedList<PathNode> path, Dtobase target);

        /// <summary>
        /// Gets top node target
        /// </summary>
        /// <param name="path">existing path</param>
        /// <returns>target DTO object</returns>
        Dtobase GetTopNodeTarget(LinkedList<PathNode> path);
    }
}